<?php
////////////////////////////////////////////////////////////////////////////////////////////////////////
/**

 */

class Logger {
    const ADMIN_EMAIL = 'harisporcic@gmail.com';
    protected $filename = '';
    protected $rollingGzipLogger = '';

    public function __construct($filename){
        $this->filename = $filename;

        $this->rollingGzipLogger = new RollingGzipLogger($filename);
    }

    public function log($level, $message, array $context = array()){

        switch($level){
            case 'emergency':
                try{
                    mail(self::ADMIN_EMAIL, __FILE__, $message, "");
                }
                catch(Exception $exception){
                    $this->rollingGzipLogger->emergency(
                        "Email for emergency not Sending. Emergency message:  ".$message,
                        array('exception' => $exception));
                }
                $this->rollingGzipLogger->emergency($message, $context);
        }
    }



}